/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftp;

import com.quantumdata.ftp.CoFile;
import com.quantumdata.ftp.CoFilenameFilter;
import com.quantumdata.ftp.CoOrder;
import com.quantumdata.ftp.Ftp;
import com.quantumdata.ftp.FtpInputStream;
import com.quantumdata.ftp.FtpListInputStream;
import com.quantumdata.ftp.FtpOutputStream;
import com.quantumdata.std.IQDConsole;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public final class FtpFile
implements CoFile {
    private String m_name = null;
    private String m_ext = null;
    private String m_descr = "";
    private static final String[] m_months = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private static final char LINK = 'l';
    private static final char SPECIAL = 'c';
    private static final char FOLDER = 'd';
    private static final char FILE = '-';
    private Ftp m_client = null;
    private String m_access = null;
    private String m_owner = null;
    private String m_group = null;
    private long m_size = 0L;
    private long m_date = 0L;
    private String m_path = null;

    private void sortSetup(String string) {
        this.m_name = string.toUpperCase();
        int n = this.m_name.lastIndexOf(".");
        this.m_ext = n != -1 && n < this.m_name.length() ? this.m_name.substring(n) : " " + this.m_name;
    }

    public int compareNameToIgnoreCase(CoOrder coOrder) {
        if (coOrder instanceof FtpFile) {
            FtpFile ftpFile = (FtpFile)coOrder;
            return this.m_name.compareTo(ftpFile.m_name);
        }
        throw new ClassCastException();
    }

    public int compareExtToIgnoreCase(CoOrder coOrder) {
        if (coOrder instanceof FtpFile) {
            FtpFile ftpFile = (FtpFile)coOrder;
            int n = this.m_ext.compareTo(ftpFile.m_ext);
            if (n == 0) {
                n = this.m_name.compareTo(ftpFile.m_name);
            }
            return n;
        }
        throw new ClassCastException();
    }

    public boolean startsWithIgnoreCase(char c) {
        return this.m_name.charAt(0) == Character.toUpperCase(c);
    }

    public boolean equalsExtTo(String string) {
        return this.m_ext.compareTo(string) == 0;
    }

    public boolean equalsExtTo(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.m_ext.compareTo(stringArray[i]) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int compareToObj(Object object) {
        String string;
        String string2 = this.getHost() + this.getAbsolutePath();
        if (object instanceof CoFile) {
            CoFile coFile = (CoFile)object;
            string = coFile.getHost() + coFile.getAbsolutePath();
        } else if (object instanceof String) {
            string = (String)object;
        } else {
            throw new ClassCastException();
        }
        return string2.compareTo(string);
    }

    public int compareTo(Object object) {
        return this.compareToObj(object);
    }

    public boolean isConnected() {
        return this.m_client.isConnected();
    }

    public char getDataType() {
        return 'I';
    }

    public InputStream getInputStream() throws IOException {
        return new FtpInputStream(this);
    }

    public OutputStream getOutputStream() throws IOException {
        return new FtpOutputStream(this, false);
    }

    public OutputStream getOutputStream(boolean bl) throws IOException {
        return new FtpOutputStream(this, bl);
    }

    public CoFile newFileChild(String string) {
        return new FtpFile(this, string, this.m_client);
    }

    public CoFile newFileRename(String string) {
        return new FtpFile(this.getParent(), string, this.m_client);
    }

    public IQDConsole getConsole() {
        return this.m_client.getContext().getConsole();
    }

    private FtpFile() {
    }

    public FtpFile(String string, Ftp ftp) {
        this.m_access = "d?????????";
        this.m_owner = "";
        this.m_group = "";
        this.m_size = -1L;
        this.m_date = 0L;
        this.m_path = string.compareTo("/") != 0 && string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
        this.m_client = ftp;
        this.sortSetup(this.getName());
    }

    public FtpFile(String string, String string2, Ftp ftp) {
        this.m_access = "f?????????";
        this.m_owner = "";
        this.m_group = "";
        this.m_size = -1L;
        this.m_date = 0L;
        this.m_path = string.endsWith("/") ? string + string2 : string + "/" + string2;
        this.m_client = ftp;
        this.sortSetup(string2);
    }

    public FtpFile(FtpFile ftpFile, String string, Ftp ftp) {
        this(ftpFile.toString(), string, ftp);
    }

    public Ftp getClient() {
        return this.m_client;
    }

    public String getHost() {
        String string = "";
        try {
            string = this.m_client.host();
        }
        catch (IOException iOException) {
            this.m_client.getContext().printlog("< File: Can't obtain host name. >\n" + iOException);
        }
        return string;
    }

    public String getAbsolutePath() {
        return this.m_path;
    }

    public void setAbsolutePath(String string) {
        this.m_path = string;
    }

    public int getPathDepth() {
        int n = -1;
        int n2 = -1;
        while ((n2 = this.m_path.indexOf(47, n2 + 1)) >= 0) {
            ++n;
        }
        if (!this.m_path.endsWith("/")) {
            ++n;
        }
        return n;
    }

    public CoFile getPathFragment(int n) {
        if (n > 0) {
            int n2 = -1;
            for (int i = 0; i <= n && (n2 = this.m_path.indexOf(47, n2 + 1)) >= 0; ++i) {
            }
            if (n2 > 0) {
                return new FtpFile(this.m_path.substring(0, n2), this.m_client);
            }
            return this;
        }
        return new FtpFile("/", this.m_client);
    }

    public String[] getPathArray() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.getHost());
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_path, "/");
        try {
            while (true) {
                String string = stringTokenizer.nextToken();
                vector.addElement(string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
    }

    public String getName() {
        if (this.m_path.lastIndexOf(47) >= 0) {
            return this.m_path.substring(this.m_path.lastIndexOf(47) + 1);
        }
        return this.m_path;
    }

    public String getParent() {
        if (this.m_path.lastIndexOf(47) > 0) {
            return this.m_path.substring(0, this.m_path.lastIndexOf(47));
        }
        return new String("/");
    }

    public boolean delete() throws SecurityException {
        if (this.isDirectory()) {
            this.m_client.cd(this.getParent());
            if (this.m_client.rmdir(this.m_path)) {
                return true;
            }
            return this.m_client.rm(this.m_path);
        }
        if (this.m_client.rm(this.m_path)) {
            return true;
        }
        this.m_client.cd(this.getParent());
        return this.m_client.rmdir(this.m_path);
    }

    public boolean mkdir() throws SecurityException {
        return this.m_client.mkdir(this.m_path);
    }

    public boolean mkdirs() throws SecurityException {
        boolean bl = true;
        int n = this.getPathDepth();
        for (int i = 0; i < n; ++i) {
            FtpFile ftpFile = (FtpFile)this.getPathFragment(i);
            if (ftpFile.mkdir()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean renameTo(CoFile coFile) throws SecurityException {
        return this.m_client.mv(this.m_path, coFile.getAbsolutePath());
    }

    public long length() {
        return this.m_size;
    }

    public long lastModified() {
        return this.m_date;
    }

    public String lastModifiedString() {
        return DateFormat.getDateTimeInstance(3, 3).format(new Date(this.lastModified()));
    }

    public boolean isAbsolute() {
        return this.m_path.charAt(0) == '/';
    }

    public boolean isDirectory() {
        return this.m_access.charAt(0) == 'd';
    }

    public boolean isFile() {
        return this.m_access.charAt(0) == '-';
    }

    public boolean isSpecial() {
        return this.m_access.charAt(0) == 'c';
    }

    public boolean isLink() {
        return this.m_access.charAt(0) == 'l';
    }

    public boolean isExecutable() {
        return this.m_access.indexOf(120) != -1;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public boolean exists() {
        return false;
    }

    public String getAccess() {
        return this.m_access;
    }

    public String getOwner() {
        return this.m_owner;
    }

    public String getGroup() {
        return this.m_group;
    }

    public String propertyString() {
        String string = this.getAccess() + " " + this.getOwner() + " " + this.getGroup();
        return this.isFile() ? "" + this.length() + " " + string : string;
    }

    public CoFile[] listCoRoots() {
        CoFile[] coFileArray = new FtpFile[]{this.getPathFragment(0)};
        return coFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoFile[] listCoFiles() throws SecurityException {
        Object[] objectArray = null;
        Reader reader = null;
        int n = this.m_client.getContext().getListCommandMode();
        try {
            String string;
            boolean bl = false;
            Vector<FtpFile> vector = new Vector<FtpFile>();
            reader = new BufferedReader(new InputStreamReader(new FtpListInputStream(this)));
            while ((string = ((BufferedReader)reader).readLine()) != null) {
                try {
                    switch (n) {
                        case 1: {
                            FtpFile ftpFile = FtpFile.examineListLine(this, string);
                            if (ftpFile == null) break;
                            vector.addElement(ftpFile);
                            break;
                        }
                        case 2: {
                            if (string.startsWith("/") && string.endsWith(":")) break;
                            if (string.indexOf("//") != -1) {
                                string = string.substring(string.lastIndexOf(47) + 1);
                            }
                        }
                        case 3: 
                        case 4: {
                            if (string.length() <= 0) break;
                            vector.addElement(FtpFile.examineNameListLine(this, string, n));
                            break;
                        }
                        case 5: {
                            vector.addElement(FtpFile.examineUnixListLine(this, string));
                        }
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (bl || noSuchElementException.getMessage() != null && noSuchElementException.getMessage().equals("skip")) continue;
                    this.m_client.printlog("\n   < File: Invalid List Format ! >" + (noSuchElementException.getMessage() != null ? "\n   " + noSuchElementException.getMessage() : "") + "\n   Line: " + string + "\n   Try: 'NAME_LIST' List Command");
                    bl = true;
                }
            }
            objectArray = new FtpFile[vector.size()];
            vector.copyInto(objectArray);
        }
        catch (IOException iOException) {
            this.m_client.printlog("< File: Can't list directory! >\n" + iOException);
        }
        finally {
            try {
                if (reader != null) {
                    Reader reader2 = reader;
                    reader = null;
                    reader2.close();
                }
            }
            catch (IOException iOException) {
                this.m_client.printerr(iOException);
            }
        }
        return objectArray;
    }

    public CoFile[] listCoFiles(CoFilenameFilter coFilenameFilter) throws SecurityException {
        Object[] objectArray = (FtpFile[])this.listCoFiles();
        if (objectArray == null) {
            return null;
        }
        if (coFilenameFilter != null) {
            Vector<Object> vector = new Vector<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!coFilenameFilter.accept(this, ((FtpFile)objectArray[i]).getName())) continue;
                vector.addElement(objectArray[i]);
            }
            objectArray = new FtpFile[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    private static FtpFile examineListLine(FtpFile ftpFile, String string) throws NoSuchElementException {
        if (string.length() == 0) {
            return null;
        }
        if ("0123456789".indexOf(string.charAt(0)) < 0) {
            return FtpFile.examineUnixListLine(ftpFile, string);
        }
        return FtpFile.examineWinListLine(ftpFile, string);
    }

    private static FtpFile examineNameListLine(FtpFile ftpFile, String string, int n) throws NoSuchElementException {
        FtpFile ftpFile2 = new FtpFile();
        ftpFile2.m_client = ftpFile.m_client;
        switch (n) {
            case 2: {
                if (string.indexOf(46) != -1) {
                    ftpFile2.m_access = "-?????????";
                    break;
                }
                ftpFile2.m_access = "d?????????";
                break;
            }
            case 3: {
                if (string.endsWith("/")) {
                    ftpFile2.m_access = "d?????????";
                    string = string.substring(0, string.length() - 1);
                    break;
                }
                ftpFile2.m_access = "-?????????";
                break;
            }
            case 4: {
                if (string.endsWith("/")) {
                    ftpFile2.m_access = "d?????????";
                    string = string.substring(0, string.length() - 1);
                    break;
                }
                if (string.endsWith("*")) {
                    ftpFile2.m_access = "-??x??x??x";
                    string = string.substring(0, string.length() - 1);
                    break;
                }
                if (string.endsWith("@")) {
                    ftpFile2.m_access = "l?????????";
                    string = string.substring(0, string.length() - 1);
                    break;
                }
                ftpFile2.m_access = "-?????????";
            }
        }
        ftpFile2.m_owner = "";
        ftpFile2.m_group = "";
        ftpFile2.m_size = -1L;
        ftpFile2.m_date = 0L;
        ftpFile2.m_path = ftpFile.getAbsolutePath();
        ftpFile2.m_path = !ftpFile2.m_path.endsWith("/") ? ftpFile2.m_path + '/' + string : ftpFile2.m_path + string;
        ftpFile2.sortSetup(string);
        if (ftpFile2.getName().compareTo(".") == 0 || ftpFile2.getName().compareTo("..") == 0) {
            throw new NoSuchElementException("skip");
        }
        return ftpFile2;
    }

    private static FtpFile examineWinListLine(FtpFile ftpFile, String string) throws NoSuchElementException {
        FtpFile ftpFile2 = new FtpFile();
        ftpFile2.m_client = ftpFile.m_client;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            ftpFile2.m_date = FtpFile.examineWinListDate(stringTokenizer.nextToken(), stringTokenizer.nextToken());
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("<DIR>")) {
                ftpFile2.m_access = "d?????????";
                ftpFile2.m_size = -1L;
            } else {
                ftpFile2.m_access = "-?????????";
                ftpFile2.m_size = Long.parseLong(string2);
            }
            String string3 = stringTokenizer.nextToken("").trim();
            ftpFile2.m_owner = "";
            ftpFile2.m_group = "";
            ftpFile2.m_path = ftpFile.toString();
            ftpFile2.m_path = !ftpFile2.m_path.endsWith("/") ? ftpFile2.m_path + '/' + string3 : ftpFile2.m_path + string3;
            ftpFile2.sortSetup(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NoSuchElementException("Win-List: Invalid Number Format");
        }
        if (ftpFile2.getName().compareTo(".") == 0 || ftpFile2.getName().compareTo("..") == 0) {
            throw new NoSuchElementException("skip");
        }
        return ftpFile2;
    }

    private static long examineWinListDate(String string, String string2) {
        Calendar calendar = Calendar.getInstance();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            n3 = n3 >= 70 ? (n3 += 1900) : (n3 += 2000);
            stringTokenizer = new StringTokenizer(string2, ":APM");
            calendar.set(n3, n, n2, (string2.endsWith("PM") ? 12 : 0) + Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NoSuchElementException("Win-List: Invalid Date Format");
        }
        return calendar.getTime().getTime();
    }

    private static FtpFile examineUnixListLine(FtpFile ftpFile, String string) throws NoSuchElementException {
        FtpFile ftpFile2 = new FtpFile();
        ftpFile2.m_client = ftpFile.m_client;
        try {
            if (string.indexOf("->") >= 0) {
                string = string.substring(0, string.indexOf("->"));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            ftpFile2.m_access = stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            ftpFile2.m_owner = stringTokenizer.nextToken();
            ftpFile2.m_group = stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            if (string2.endsWith(",")) {
                string2 = string2.substring(0, string2.indexOf(","));
            }
            String string3 = string2;
            if (ftpFile2.m_access.startsWith("c")) {
                string3 = stringTokenizer.nextToken();
            }
            if ("0123456789".indexOf(string3.charAt(0)) < 0) {
                string2 = ftpFile2.m_group;
                ftpFile2.m_group = "";
            }
            ftpFile2.m_size = Integer.parseInt(string2);
            ftpFile2.m_date = FtpFile.examineUnixListDate("0123456789".indexOf(string3.charAt(0)) < 0 ? string3 : stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken());
            String string4 = stringTokenizer.nextToken("").trim();
            ftpFile2.m_path = ftpFile.toString();
            ftpFile2.m_path = !ftpFile2.m_path.endsWith("/") ? ftpFile2.m_path + '/' + string4 : ftpFile2.m_path + string4;
            ftpFile2.sortSetup(string4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NoSuchElementException("Unix-List: Invalid Number Format");
        }
        catch (NoSuchElementException noSuchElementException) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (!stringTokenizer.nextToken().equals("total")) {
                    throw noSuchElementException;
                }
                Long.parseLong(stringTokenizer.nextToken());
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new NoSuchElementException("skip");
                }
                throw noSuchElementException;
            }
            catch (NumberFormatException numberFormatException) {
                throw noSuchElementException;
            }
        }
        if (ftpFile2.getName().compareTo(".") == 0 || ftpFile2.getName().compareTo("..") == 0) {
            throw new NoSuchElementException("skip");
        }
        return ftpFile2;
    }

    private static long examineUnixListDate(String string, String string2, String string3) {
        Calendar calendar = Calendar.getInstance();
        string = string.toUpperCase();
        try {
            for (int i = 0; i < 12; ++i) {
                if (!string.equals(m_months[i])) continue;
                if (string3.indexOf(58) != -1) {
                    calendar.setTime(new Date(System.currentTimeMillis()));
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
                    calendar.set(calendar.get(1), i, Integer.parseInt(string2), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                } else {
                    calendar.set(Integer.parseInt(string3), i, Integer.parseInt(string2), 0, 0);
                }
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new NoSuchElementException("Unix-List: Invalid Date Format");
        }
        return calendar.getTime().getTime();
    }

    public String toString() {
        return this.getAbsolutePath();
    }

    public void setDescription(String string) {
        this.m_descr = string;
    }

    public String getDescription() {
        return this.m_descr;
    }
}

